package w83a.w83aBeans;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.w83aDAO.w83aConstantesBD.W83aDelegacionesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aUsuariosBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import w83a.w83aUtilidadesComunes.W83aUtilidadesN38API;

/**
 * 
 * 
 * @author jroncal
 * 
 */
public class W83aUsuarioXLNetsBean extends W83aBaseBean implements W83aBaseBeanBD{
	private static final long	serialVersionUID	= 1L;

	private String idUsuario = null;
	private String dniUsuario = null;
	private String nombreUsuario = null;
	private String nombrePersona = null;
	
	private String codTerritorioDelegacion = null;
	private String calleDelegacion = null;
	private String numeroDelegacion = null;
	private String pisoDelegacion = null;
	private String letraDelegacion = null;
	private String codigoPostalDelegacion = null;
	private String localidadDelegacion = null;
	private String localidadTxtCastDelegacion = null;
	private String localidadTxtEuskDelegacion = null;
	private String telefono1Delegacion = null;
	private String telefono2Delegacion = null;
	private String faxDelegacion = null;
	private String regManual = null;
	private String modelo = null;
	private String modeloSal = null;
	private String localidadTxtCastDelegacionMin = null;
	private String localidadTxtEuskDelegacionMin = null;
	
	private String sessionTokenXLNets = "";
	private Document sessionTokenXLNetsDoc;
	private String loginXLNets = null;
	private List perfilXLNets = new ArrayList();

	//datos para el registro en el libro
	private String fechaRegistro = null;
	private String numRegistro = null;
	private String empresa = null;
	private String poblacion = null;
	private String observaciones = null;
	private String tipo = null;
	private String existeEnBD=null;
	private String dniCompleto=null;
	
	//Datos de la tarjeta
	private String xmlThirdPartySession;
	
	public String getDniCompleto() {
		return dniCompleto;
	}
	public void setDniCompleto(String dniCompleto) {
		this.dniCompleto = dniCompleto;
	}
	public String getLocalidadTxtCastDelegacionMin() {
		return localidadTxtCastDelegacionMin;
	}
	public void setLocalidadTxtCastDelegacionMin(
			String localidadTxtCastDelegacionMin) {
		this.localidadTxtCastDelegacionMin = localidadTxtCastDelegacionMin;
	}
	public String getLocalidadTxtEuskDelegacionMin() {
		return localidadTxtEuskDelegacionMin;
	}
	public void setLocalidadTxtEuskDelegacionMin(
			String localidadTxtEuskDelegacionMin) {
		this.localidadTxtEuskDelegacionMin = localidadTxtEuskDelegacionMin;
	}
	public String getIdUsuario() {
		return idUsuario;
	}
	public void setIdUsuario(String idUsuario) {
		this.idUsuario = idUsuario;
	}
	public String getDniUsuario() {
		return dniUsuario;
	}
	public void setDniUsuario(String dniUsuario) {
		this.dniUsuario = dniUsuario;
	}
	public String getNombreUsuario() {
		return nombreUsuario;
	}
	public void setNombreUsuario(String nombreUsuario) {
		this.nombreUsuario = nombreUsuario;
	}
	public List getPerfilXLNets() {
		return perfilXLNets;
	}
	public void setPerfilXLNets(List perfilXLNets) {
		this.perfilXLNets = perfilXLNets;
	}		
	public String getLoginXLNets() {
		return loginXLNets;
	}
	public void setLoginXLNets(String loginXLNets) {
		this.loginXLNets = loginXLNets;
	}
	public String getCodTerritorioDelegacion() {
		return codTerritorioDelegacion;
	}
	public void setCodTerritorioDelegacion(String codTerritorioDelegacion) {
		this.codTerritorioDelegacion = codTerritorioDelegacion;
	}
	public String getCalleDelegacion() {
		return calleDelegacion;
	}
	public void setCalleDelegacion(String calleDelegacion) {
		this.calleDelegacion = calleDelegacion;
	}
	public String getNumeroDelegacion() {
		return numeroDelegacion;
	}
	public void setNumeroDelegacion(String numeroDelegacion) {
		this.numeroDelegacion = numeroDelegacion;
	}
	public String getPisoDelegacion() {
		return pisoDelegacion;
	}
	public void setPisoDelegacion(String pisoDelegacion) {
		this.pisoDelegacion = pisoDelegacion;
	}
	public String getLetraDelegacion() {
		return letraDelegacion;
	}
	public void setLetraDelegacion(String letraDelegacion) {
		this.letraDelegacion = letraDelegacion;
	}
	public String getCodigoPostalDelegacion() {
		return codigoPostalDelegacion;
	}
	public void setCodigoPostalDelegacion(String codigoPostalDelegacion) {
		this.codigoPostalDelegacion = codigoPostalDelegacion;
	}
	public String getLocalidadDelegacion() {
		return localidadDelegacion;
	}
	public void setLocalidadDelegacion(String localidadDelegacion) {
		this.localidadDelegacion = localidadDelegacion;
	}
	public String getTelefono1Delegacion() {
		return telefono1Delegacion;
	}
	public void setTelefono1Delegacion(String telefono1Delegacion) {
		this.telefono1Delegacion = telefono1Delegacion;
	}
	public String getTelefono2Delegacion() {
		return telefono2Delegacion;
	}
	public void setTelefono2Delegacion(String telefono2Delegacion) {
		this.telefono2Delegacion = telefono2Delegacion;
	}
	public String getFaxDelegacion() {
		return faxDelegacion;
	}
	public void setFaxDelegacion(String faxDelegacion) {
		this.faxDelegacion = faxDelegacion;
	}	
	public String getSessionTokenXLNets() {
		return sessionTokenXLNets;
	}
	public void setSessionTokenXLNets(String sessionTokenXLNets) {
		this.sessionTokenXLNets = sessionTokenXLNets;
	}
	
	public Document getSessionTokenXLNetsDoc() {
		return sessionTokenXLNetsDoc;
	}
	public void setSessionTokenXLNetsDoc(Document sessionTokenXLNetsDoc) {
		this.sessionTokenXLNetsDoc = sessionTokenXLNetsDoc;
	}
	public String getPermisoXlnet(){
		return W83aUtilidadesN38API.elegirServiciosCentralosODelegacion(this.getPerfilXLNets());
	}
	
	public String getNombrePersona() {
		return nombrePersona;
	}
	public void setNombrePersona(String nombrePersona) {
		this.nombrePersona = nombrePersona;
	}
	
	
	public String getRegManual() {
		return regManual;
	}
	public void setRegManual(String regManual) {
		this.regManual = regManual;
	}
	
	public String getModelo() {
		return modelo;
	}
	public void setModelo(String modelo) {
		this.modelo = modelo;
	}
	
	public String getModeloSal() {
		return modeloSal;
	}
	public void setModeloSal(String modeloSal) {
		this.modeloSal = modeloSal;
	}
	
	public String getExisteEnBD() {
		return existeEnBD;
	}
	public void setExisteEnBD(String existeEnBD) {
		this.existeEnBD = existeEnBD;
	}
	public String getCalleListadosFormateada(){
		StringBuffer calle = new StringBuffer();
		W83aClsTrazas.trazaError(null,"W83aUsuarioXLNetsBean calleDelegacion - "+this.calleDelegacion,null);
		calle.append(this.calleDelegacion);
		
		if(StringUtils.isNotEmpty(this.numeroDelegacion)){
			calle.append(" n ").append(this.numeroDelegacion);
		}
		
		if(StringUtils.isNotEmpty(this.pisoDelegacion)){
			calle.append(this.pisoDelegacion).append("");
		}
		
		if(StringUtils.isNotEmpty(this.telefono1Delegacion)){
			calle.append(" - Tel ").append(this.telefono1Delegacion);
		}
		
		if(StringUtils.isNotEmpty(this.faxDelegacion)){
			calle.append(" - Fax ").append(this.faxDelegacion);
		}
		
		if(StringUtils.isNotEmpty(this.codigoPostalDelegacion)||
			StringUtils.isNotEmpty(this.localidadDelegacion)){
			calle.append(" -");
		}
		
		if(StringUtils.isNotEmpty(this.codigoPostalDelegacion)){
			calle.append(" ").append(this.codigoPostalDelegacion);			
		}
		
		if(StringUtils.isNotEmpty(this.localidadTxtCastDelegacion)){
			calle.append(" ").append(this.localidadTxtCastDelegacion);			
		}
		
		return calle.toString();
	}
	
	public String getLocalidadTxtCastDelegacion() {
		return localidadTxtCastDelegacion;
	}
	public void setLocalidadTxtCastDelegacion(String localidadTxtCastDelegacion) {
		this.localidadTxtCastDelegacion = localidadTxtCastDelegacion;
	}
	public String getLocalidadTxtEuskDelegacion() {
		return localidadTxtEuskDelegacion;
	}
	
	
	
	public String getFechaRegistro() {
		return fechaRegistro;
	}
	public void setFechaRegistro(String fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}
	public String getNumRegistro() {
		return numRegistro;
	}
	public void setNumRegistro(String numRegistro) {
		this.numRegistro = numRegistro;
	}
	public void setLocalidadTxtEuskDelegacion(String localidadTxtEuskDelegacion) {
		this.localidadTxtEuskDelegacion = localidadTxtEuskDelegacion;
	}
	
	public String getEmpresa() {
		return empresa;
	}
	public void setEmpresa(String empresa) {
		this.empresa = empresa;
	}
	
	public String getPoblacion() {
		return poblacion;
	}
	public void setPoblacion(String poblacion) {
		this.poblacion = poblacion;
	}
	public String getObservaciones() {
		return observaciones;
	}
	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}
	
	public String getTipo() {
		return tipo;
	}
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}
	
	public String getXmlThirdPartySession() {
		return xmlThirdPartySession;
	}
	public void setXmlThirdPartySession(String xmlThirdPartySession) {
		this.xmlThirdPartySession = xmlThirdPartySession;
	}
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		// TODO Auto-generated method stub
		ResultSet rs = (ResultSet)o;//NOPMD
		
		W83aUsuarioXLNetsBean beanUsuarioBase = (W83aUsuarioXLNetsBean)((List)otrosValores).get(0);
		String modo = (String)((List)otrosValores).get(1);
		
		if("completo".equals(modo)){
			StringBuffer nombrecompleto=new StringBuffer(W83aClsConstantes.CUARENTA);
			nombrecompleto.append(W83aDataBase.getStringFromRS(rs, W83aUsuariosBD.nombre)).append(" ").append(W83aDataBase.getStringFromRS(rs, W83aUsuariosBD.apellido1)).append(" ").append(W83aDataBase.getStringFromRS(rs, W83aUsuariosBD.apellido2));
			this.dniUsuario = beanUsuarioBase.getDniUsuario();
			this.idioma = beanUsuarioBase.getIdioma();
			this.loginXLNets = beanUsuarioBase.getLoginXLNets();
			//this.nombrePersona = beanUsuarioBase.getNombrePersona();
			this.nombrePersona = nombrecompleto.toString(); 
			this.perfilXLNets = beanUsuarioBase.getPerfilXLNets();
			this.sessionTokenXLNets = beanUsuarioBase.getSessionTokenXLNets();
			this.sessionTokenXLNetsDoc = beanUsuarioBase.getSessionTokenXLNetsDoc();
			this.idUsuario = beanUsuarioBase.getIdUsuario();
			
			this.xmlThirdPartySession = beanUsuarioBase.getXmlThirdPartySession();
			
			this.codTerritorioDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.C_TERRIT_051);
			this.calleDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.CALLE_051);
			this.numeroDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.NUM_051);
			this.pisoDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.PISO_051);
			this.letraDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.LETRA_051);
			this.codigoPostalDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.CP_051);
			this.localidadDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.LOCALIDAD_051);
			this.localidadTxtCastDelegacion = W83aDataBase.getStringFromRS(rs, "TXTCASLOCALIDAD");
			this.localidadTxtEuskDelegacion = W83aDataBase.getStringFromRS(rs, "TXTEUSLOCALIDAD");
			this.localidadTxtCastDelegacionMin = W83aDataBase.getStringFromRS(rs, "TXTCASLOCALIDADMIN");
			this.localidadTxtEuskDelegacionMin = W83aDataBase.getStringFromRS(rs, "TXTEUSLOCALIDADMIN");
			this.telefono1Delegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.TELEFONO1_051);
			this.telefono2Delegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.TELEFONO2_O51);
			this.faxDelegacion = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.FAX_051);
			this.regManual = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.REG_MANUAL_051);
			this.modelo = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.NUMMOD_051);
			this.modeloSal = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.NUMMODSAL_051);
		}else if("parcial".equals(modo)){
			this.dniUsuario = beanUsuarioBase.getDniUsuario();
			this.idioma = beanUsuarioBase.getIdioma();
			this.loginXLNets = beanUsuarioBase.getLoginXLNets();
			this.nombrePersona = beanUsuarioBase.getNombrePersona();
			this.perfilXLNets = beanUsuarioBase.getPerfilXLNets();
			this.sessionTokenXLNets = beanUsuarioBase.getSessionTokenXLNets();
			this.sessionTokenXLNetsDoc = beanUsuarioBase.getSessionTokenXLNetsDoc();
			this.idUsuario = beanUsuarioBase.getIdUsuario();
			this.xmlThirdPartySession = beanUsuarioBase.getXmlThirdPartySession();
			
			this.codTerritorioDelegacion = beanUsuarioBase.getCodTerritorioDelegacion();
			this.calleDelegacion = beanUsuarioBase.getCalleDelegacion();
			this.numeroDelegacion = beanUsuarioBase.getNumeroDelegacion();
			this.pisoDelegacion = beanUsuarioBase.getPisoDelegacion();
			this.letraDelegacion = beanUsuarioBase.getLetraDelegacion();
			this.codigoPostalDelegacion = beanUsuarioBase.getCodigoPostalDelegacion();
			this.localidadDelegacion = beanUsuarioBase.getLocalidadDelegacion();
			this.localidadTxtCastDelegacion = beanUsuarioBase.getLocalidadTxtCastDelegacion();
			this.localidadTxtEuskDelegacion = beanUsuarioBase.getLocalidadTxtEuskDelegacion();
			this.localidadTxtCastDelegacionMin = beanUsuarioBase.getLocalidadTxtCastDelegacionMin();
			this.localidadTxtEuskDelegacionMin = beanUsuarioBase.getLocalidadTxtEuskDelegacionMin();
			this.telefono1Delegacion = beanUsuarioBase.getTelefono1Delegacion();
			this.telefono2Delegacion = beanUsuarioBase.getTelefono2Delegacion();
			this.faxDelegacion = beanUsuarioBase.getFaxDelegacion();
			this.regManual = beanUsuarioBase.getRegManual();
			
			this.empresa = beanUsuarioBase.getEmpresa();
			this.poblacion = beanUsuarioBase.getPoblacion();
			this.observaciones = beanUsuarioBase.getObservaciones();
			this.tipo = beanUsuarioBase.getTipo();
			
			this.modelo = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.NUMMOD_051);
			this.modeloSal = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.NUMMODSAL_051);			
		}else if("parcialRegistroAutomat".equals(modo)){
			this.dniUsuario = beanUsuarioBase.getDniUsuario();
			this.idioma = beanUsuarioBase.getIdioma();
			this.loginXLNets = beanUsuarioBase.getLoginXLNets();
			this.nombrePersona = beanUsuarioBase.getNombrePersona();
			this.perfilXLNets = beanUsuarioBase.getPerfilXLNets();
			this.sessionTokenXLNets = beanUsuarioBase.getSessionTokenXLNets();
			this.sessionTokenXLNetsDoc = beanUsuarioBase.getSessionTokenXLNetsDoc();
			this.idUsuario = beanUsuarioBase.getIdUsuario();
			this.xmlThirdPartySession = beanUsuarioBase.getXmlThirdPartySession();
			
			this.codTerritorioDelegacion = beanUsuarioBase.getCodTerritorioDelegacion();
			this.calleDelegacion = beanUsuarioBase.getCalleDelegacion();
			this.numeroDelegacion = beanUsuarioBase.getNumeroDelegacion();
			this.pisoDelegacion = beanUsuarioBase.getPisoDelegacion();
			this.letraDelegacion = beanUsuarioBase.getLetraDelegacion();
			this.codigoPostalDelegacion = beanUsuarioBase.getCodigoPostalDelegacion();
			this.localidadDelegacion = beanUsuarioBase.getLocalidadDelegacion();
			this.localidadTxtCastDelegacion = beanUsuarioBase.getLocalidadTxtCastDelegacion();
			this.localidadTxtEuskDelegacion = beanUsuarioBase.getLocalidadTxtEuskDelegacion();
			this.localidadTxtCastDelegacionMin = beanUsuarioBase.getLocalidadTxtCastDelegacionMin();
			this.localidadTxtEuskDelegacionMin = beanUsuarioBase.getLocalidadTxtEuskDelegacionMin();
			this.telefono1Delegacion = beanUsuarioBase.getTelefono1Delegacion();
			this.telefono2Delegacion = beanUsuarioBase.getTelefono2Delegacion();
			this.faxDelegacion = beanUsuarioBase.getFaxDelegacion();
			this.regManual = W83aDataBase.getStringFromRS(rs, W83aDelegacionesBD.REG_MANUAL_051);
			
			this.empresa = beanUsuarioBase.getEmpresa();
			this.poblacion = beanUsuarioBase.getPoblacion();
			this.observaciones = beanUsuarioBase.getObservaciones();
			this.tipo = beanUsuarioBase.getTipo();
			
			this.modelo = beanUsuarioBase.getModelo();
			this.modeloSal = beanUsuarioBase.getModeloSal();			
		}
		
		return beanUsuarioBase;
	}

}
